/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.HotplugEventType;
import com.quantumdata.busmon.parser.TypeConverter;

public class HotplugDataBlock
extends DataBlock {
    protected HotplugEventType eventType = HotplugEventType.RISING_EDGE;
    protected int sourceID;
    protected long timestamp = 0L;

    public boolean parse(Integer[] integerArray) {
        switch (integerArray[7]) {
            case 1: {
                this.eventType = HotplugEventType.RISING_EDGE;
                break;
            }
            case 2: {
                this.eventType = HotplugEventType.FALLING_EDGE;
                break;
            }
            default: {
                this.eventType = HotplugEventType.UNKNOWN;
            }
        }
        this.sourceID = integerArray[8];
        this.timestamp = TypeConverter.composeLong(integerArray, 9);
        return true;
    }

    public boolean isError() {
        return this.eventType != HotplugEventType.RISING_EDGE && this.eventType != HotplugEventType.FALLING_EDGE;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getType() {
        return "<html><b>HOTPLUG</b></html>";
    }

    public String getSummary() {
        switch (this.eventType) {
            case RISING_EDGE: {
                return "/ RISING edge";
            }
            case FALLING_EDGE: {
                return "\\ FALLING edge";
            }
        }
        return "ERROR: Unknown hotplug event type!?";
    }

    public String getDetails() {
        switch (this.eventType) {
            case RISING_EDGE: {
                return "The analyzer noted a low-to-high transition on the hotplug line.";
            }
            case FALLING_EDGE: {
                return "The analyzer noted a high-to-low transition on the hotplug line.";
            }
        }
        return "The analyzer sent a hotplug condition, but did not specify a valid condition type (rising or falling).";
    }
}

